<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
    <title>Login</title>
    <link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">
    <link rel="manifest" href="../assets/scripts/_manifest.json?v=2.0" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
    <link rel="icon" type="image/png" href="../../assets/img/favicon.png" />
    <style>
        body {
            margin: auto;
            background-color: #ffffff;
        }

        .title-box-container {
            background-image: url("../../assets/img/bg/cover3.jpg");
            background-repeat: no-repeat;
            background-size: cover;
            height: 200px;
        }

        .title-box-body {
            background-color: rgb(from #4782D2 r g b / 0.9);
            height: inherit;
        }

        .title-box-container2 {
            border-top-left-radius: 10%;
            border-top-right-radius: 10%;
            background-color: #ffffff;
        }

        .card {
            background: rgba(255, 255, 255, 0.9);
            margin: 20px;
            border-radius: 0px;
        }

        .form-control {
            background-color: #f2f2f2 !important;
            border-radius: 1.5rem !important;
            padding: 25px !important;
            padding-left: 50px !important;
        }

        .form-control:focus {
            background-color: #ffffff !important;
        }

        .input-style i {
            padding-left: 20px !important;
        }

        .btn {
            border-radius: 1.5rem !important;
            background-image: linear-gradient(to bottom, <?php echo $sitecolor; ?>, <?php echo $sitecolor; ?>) !important;
        }

        .color-highlight {
            color: <?php echo $sitecolor; ?> !important;
        }
    </style>
</head>

<body class="theme-light">

    <div id="page">
        <div class="page-content body-container">
            <div class="body-container-child">

                <div class="title-box-container">
                    <div class="title-box-body d-flex justify-content-center align-items-center">
                        <div>
                            <h1 class="text-white text-center"><?php echo $sitename; ?></h1>
                        </div>
                    </div>
                </div>

                <div class="title-box-container2 mt-n5">
                    <div class="user-top text-center">
                        <h1 class="font-25 pt-5 mb-3 color-highlight">LOGIN</h1>
                        <h6 class="mb-1 mt-2 color-highlight" id="accountname">Welcome To <?php echo $sitename; ?></h6>
                    </div>

                    <div class="">
                        <div class="content">
                            <form id="login-form" method="post">
                                <div class="px-2">
                                    <div class="input-style no-borders has-icon mb-2 mt-2" id="phonediv">
                                        <i class="fa fa-phone"></i>
                                        <input type="number" class="form-control" id="phonelogin" name="phone" placeholder="Phone Number" required readonly />
                                        <label for="phone" class="color-highlight">Phone</label>
                                        <em>(required)</em>
                                    </div>
                                    <div class="input-style no-borders has-icon mb-4">
                                        <i class="fa fa-lock"></i>
                                        <input type="password" class="form-control" id="passwordlogin" name="password" placeholder="Password" required readonly />
                                        <label for="password" class="color-highlight">Password</label>
                                        <em>(required)</em>
                                    </div>

                                    <button type="submit" id="submit-btn" style="width: 100%;" class="btn btn-full btn-l font-600 font-15 gradient-highlight mt-4 ">
                                        Login
                                    </button>
                                </div>
                            </form>

                            <div class="row pt-4 mb-3">
                                <div class="col-12 text-center font-15">
                                    <a class="text-dark" href="../recovery/">Forget Password? Recover It</a>
                                </div>
                                <div class="col-12 text-center font-15 mt-2">
                                    <a class="text-dark" href="../register/">New User? Create Account</a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <!-- Page content ends here-->
        </div>
    </div>

     <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script type="text/javascript">
    $("document").ready(function(){

        //Save Phone Number
        checkIfPhoneNumberSaved();

        //Enable Form Input
        $("#phonelogin").click(function(){$(this).removeAttr("readonly"); });
        $("#passwordlogin").click(function(){$(this).removeAttr("readonly"); });

        //Registration Form
        $('#login-form').submit(function(e){
                e.preventDefault()
                $('#submit-btn').removeClass("btn-primary");
                $('#submit-btn').addClass("btn-secondary");
                $('#submit-btn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');
                
                $.ajax({
                    url:'../home/includes/route.php?login',
                    data: new FormData($(this)[0]),
                    cache: false,
                    contentType: false,
                    processData: false,
                    method: 'POST',
                    type: 'POST',
                    success:function(resp){
                        
                        resp = JSON.parse(resp);

                        if(resp.status == "success"){
                            swal('Alert!!',"Login Succesfull","success");
                            setTimeout(function(){
                                location.replace('../home/')
                            },1000)
                        }
                        else{
                            swal('Alert!!',resp.msg,"error");
                        }

                    $('#submit-btn').removeClass("btn-secondary");
                    $('#submit-btn').addClass("btn-primary");
                    $('#submit-btn').html("<b>Login</b>");

                    }
                })
            });

    });

    function checkIfPhoneNumberSaved() {
        $phone = atob(unescape(getCookie("loginPhone")));
        $name = atob(unescape(getCookie("loginName")));
        if($phone != null && $phone != ""){
            let msg='<p class="mb-3"><a href="javascript:showNumber();"><b class="text-primary">Login With Another Account?</b></a></p>';
            $("#accountname").after(msg);
            $("#accountname").append(" "+$name+"!");
            $("#phonediv").hide();
            $("#phonelogin").val($phone);
        }
    }

    function showNumber(){
        $("#phonediv").show();
    }
     
    function getCookie(cname) {
        var name = cname + "=";
        var ca = document.cookie.split(';');
        for(var i=0; i<ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0)==' ') c = c.substring(1);
            if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
        }
        return "";
    }

</script>

    
</body>
</html>